#!/usr/bin/env bash

set -e

# Percorsi
IMG="initrd.gz"
RAW="initrd.img"
TMPDIR="tmp"
OUTDIR="initrd_contents"

cd hal91

# Pulizia/creazione cartelle
rm -rf "$TMPDIR" "$OUTDIR"
mkdir -p "$TMPDIR" "$OUTDIR"

# Decompressione
gzip -dc "$IMG" > "$RAW"

# Montaggio
sudo mount -o loop "$RAW" "$TMPDIR"

# Copia contenuto
cp -a "$TMPDIR"/* "$OUTDIR/"

# Smontaggio e pulizia
sudo umount "$TMPDIR"
rm -f "$RAW"
rmdir "$TMPDIR"

echo "✅ Estratto con successo in ./$OUTDIR"

